<?php


$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-backend',
    'basePath' => dirname(__DIR__),
    'controllerNamespace' => 'backend\controllers',
    'modules' => [
        'user' => [
            'class' => wdigital\cms\user\Module::class,
            'enableRegistration' => false,
            'enableConfirmation' => false,
            'enablePasswordRecovery' => true,
            'adminPermission' => '',
        ],
    ],
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-backend',
        ],
        'session' => [
            // this is the name of the session cookie used for login on the backend
            'name' => 'advanced-backend',
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'user' => [
            'identityClass' => wdigital\cms\user\models\User::class,
            'loginUrl' => ['/user/security/login'],
            'enableAutoLogin' => false,
        ],
        'assetManager' => [
            'bundles' => [
                wdigital\cms\inspinia\assets\AppAsset::class => [
                    'depends' => [
                        wdigital\cms\inspinia\assets\InspiniaAsset::class,
                    ],
                ],
            ],
            'appendTimestamp' => true,
        ],
        'i18n' => [
            'translations' => [
                '*' => [
                    'class' => yii\i18n\PhpMessageSource::class,
                    'forceTranslation'=> true,
                    'sourceLanguage' => 'en',
                ],
            ],
        ],
        'view' => [
            'theme' => [
                'basePath' => '@vendor/wdigital/cms-inspinia',
                'baseUrl' => '@vendor/wdigital/cms-inspinia',
                'pathMap' => [
                    '@app/views/layouts' => [
                        '@vendor/wdigital/cms-inspinia/src/views/layouts'
                    ],
                    '@app/views/site' => [
                        '@app/views/site',
                        '@vendor/wdigital/cms-inspinia/src/views/site'
                    ],
                    '@app/views' => '@vendor/wdigital/cms-inspinia/src/views',
                    '@vendor/wdigital/cms-user/src/views' => '@app/views/user',
                    '@vendor/dektrium/yii2-user/views' => '@app/views/user',
                ],
            ],
        ],
        'urlManager' => [
            'class' => yii\web\UrlManager::class,
            'enablePrettyUrl' => true,
            'showScriptName' => false,
        ],
    ],
    'as access' => [
        'class' => yii\filters\AccessControl::class,
        'rules' => [
            [
                'allow' => true,
                'roles' => ['@'],
            ],
            [
                'actions' => ['login', 'error', 'request', 'reset'],
                'allow' => true,
            ],
        ],
    ],
    'params' => $params,
];
