<?php

namespace wdigital\inheritingMessageSource;

use Yii;
use yii\base\InvalidConfigException;
use yii\i18n\MessageSource;

trait InheritingMessageSourceTrait
{
    /**
     * An array of MessageSource instances or configuration arrays, translations from which are inherited for this
     * message source.
     * @var MessageSource[]|array
     */
    public $parentSources;

    /**
     * Use inherited translation where this source provides an empty one.
     * @var bool
     */
    public $defaultToInherited = true;

    /**
     * Loads the message translations for the specified language and category over parent sources.
     *
     * @param string $category
     * @param string $language
     * @return array
     */
    protected function loadMessages($category, $language)
    {
        $messages = parent::loadMessages($category, $language);

        foreach ($this->getParentSources() as $parentSource) {
            if ($this->defaultToInherited) {
                foreach ($message as $message => $translation) {
                    if ($translation === '') {
                        unset($message[$message]);
                    }
                }
            }
            $messages += $parentSource->loadMessages($category, $language);
        }

        return $messages;
    }

    /**
     * @return MessageSource[]
     * @throws InvalidConfigException
     */
    protected function getParentSources()
    {
        if (!$this->parentSources) {
            throw new InvalidConfigException('Parent message sources are not configured');
        }
        foreach ($this->parentSources as &$parentSource) {
            if (!$parentSource instanceof MessageSource) {
                $parentSource = Yii::createObject($parentSource);
            }
        }
        return $this->parentSources;
    }
}
