Inheriting Yii2 Message Sources
===============================

Trait for message sources that can inherit messages from other sources and message source classes using the trait.


## Installation

### 1. Download

1. Add the WD Composer repo to your `composer.json`:

        "repositories": [{
            "type": "composer",
            "url": "https://composer.wdigital.lv"
        }]

2. Require the package by adding

        "wdigital/yii2-inheriting-message-source": "^1.0.0"

    to the `require` section of `composer.json` or run

        $ composer require wdigital/yii2-inheriting-message-source:^1.0.0


## Usage

Configure a message source as you normally would and set its `parentSources` property to an array of one or more parent
message sources providing messages for this category, e.g.:

        'i18n' => [
            // ...
            'translations' => [
                // ...
                'category*' => [
                    'class' => \wdigital\inheritingMessageSource\PhpMessageSource::class,
                    'parentSources' => [
                        // ...
                        [
                            'class' => \yii\i18n\PhpMessageSource::class,
                            // 'basePath' => '@app/messages',
                        ],
                        [
                            'class' => \yii\i18n\PhpMessageSource::class,
                            'basePath' => '@vendor/vendorName/PackageName/path/to/messages',
                        ],
                    ],
                ],
            ],
        ],

Parent sources should be in priority order, sources closer to the beginning of the array will override later sources.

By default, `defaultToInherited` is enabled, therefore empty message translations fall back to parent sources. If you
explicitly wish to fall back to the default message, set the message translation value to `false`.
