<?php

namespace wdigital\inheritingMessageSource;

use Yii;
use yii\base\InvalidConfigException;
use yii\i18n\MessageSource;

trait InheritingMessageSourceTrait
{
    /**
     * An array of MessageSource instances or configuration arrays, translations from which are inherited for this
     * message source.
     * @var MessageSource[]|array
     */
    public $parentSources;

    /**
     * Loads the message translations for the specified language and category over parent sources.
     *
     * @param string $category
     * @param string $language
     * @return array
     */
    protected function loadMessages($category, $language)
    {
        $messsages = parent::loadMessages($category, $language);

        foreach ($this->getParentSources() as $parentSource) {
            $messsages += $parentSource->loadMessages($category, $language);
        }

        return $messsages;
    }

    /**
     * @return MessageSource[]
     * @throws InvalidConfigException
     */
    protected function getParentSources()
    {
        if (!$this->parentSources) {
            throw new InvalidConfigException('Parent message sources are not configured');
        }
        foreach ($this->parentSources as &$parentSource) {
            if (!$parentSource instanceof MessageSource) {
                $parentSource = Yii::createObject($parentSource);
            }
        }
        return $this->parentSources;
    }
}
