<?php

namespace wdigital\yii2glide\controllers;

use wdigital\yii2glide\components\Glide;
use Yii;
use yii\web\BadRequestHttpException;

/**
 * This class extends standard Glide package with additional functionality that checks
 * if only allowed query string parameters are used.
 * @see \trntv\glide\controllers\GlideController
 */
class GlideController extends \trntv\glide\controllers\GlideController
{
    /**
     * @var string
     */
    public $component = 'glide';
    
    /**
     * @return Glide
     * @throws \yii\base\InvalidConfigException
     */
    public function getComponent(): Glide
    {
        return Yii::$app->get($this->component);
    }
    
    /**
     * Checks if only allowed params from whitelist are being used in the request.
     * @return bool
     */
    private function validParams(): bool
    {
        $whitelist = $this->getComponent()->whitelist;
        foreach (Yii::$app->request->get() as $paramName => $value) {
            if (!isset($whitelist[$paramName]) || $whitelist[$paramName] !== '*' && !in_array($value, $whitelist[$paramName], true)) {
                return false;
            }
        }
        //currently, body params are not being used by glide package, but this check is just in case
        if (!empty(Yii::$app->request->getBodyParams())) {
            return false;
        }
        return true;
    }
    
    /**
     * {@inheritdoc}
     * @throws BadRequestHttpException
     */
    public function beforeAction($action): bool
    {
        if (!parent::beforeAction($action)) {
            return false;
        }
        if (!$this->validParams()) {
            throw new BadRequestHttpException(Yii::t('yii', 'Invalid request params.'));
        }
        return true;
    }
}
