<?php

namespace wdigital\yii2glide\components;

use yii\base\InvalidConfigException;

/**
 * Glide component
 */
class Glide extends trntv\glide\components\Glide
{
    /**
     * @var array
     */
    public $whitelist;
    
    /**
     * {@inheritdoc}
     * @throws InvalidConfigException
     */
    public function init(): void
    {
        if (!is_array($this->whitelist)) {
            throw new InvalidConfigException('Glide package whitelist of allowed query string parameters must be defined');
        }
        //convert to string to allow using int in config, because controller uses ===
        foreach ($this->whitelist as &$whitelistElem) {
            foreach ($whitelistElem as &$value) {
                $value = (string) $value;
            }
            unset($value);
        }
        unset($whitelistElem);
        parent::init();
    }
}
