Glide package
===============================

This package extends standard Glide package with additional functionality that checks if only allowed query string parameters are used. This is needed to prevent Glide cache from growing infinitely due to malicious requests.


## Installation

Add the WD Composer repo to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

Require the package by adding

    "wdigital/yii2-glide": "^1.0.0"

to the `require` section of `composer.json` or run

    $ composer require wdigital/yii2-glide:^1.0.0


## Usage

Configure component, using `whitelist` property for allowed parameters:

    'components' => [
        // ...
        'glide' => [
            'class' => wdigital\yii2glide\components\Glide::class,
            // ...
            'whitelist' => [
                'w' => [300, 400],
                'h' => ['100', 200],    //can use both string and int
                'fit' => ['crop'],
                // ...
            ],
        ],
    ],

Configure controller map:

    'controllerMap' => [
        // ...
        'media' => wdigital\yii2glide\controllers\GlideController::class,
    ],

Requests that use either parameter values or parameter names not specified in the whitelist will be denied.
