<?php

namespace wdigital\yii2glide\controllers;

use wdigital\yii2glide\components\Glide;
use Yii;
use yii\web\BadRequestHttpException;

/**
 * Glide controller
 */
class GlideController extends \trntv\glide\controllers\GlideController
{
    /**
     * @var string
     */
    public $component = 'glide';
    
    /**
     * @return Glide
     * @throws \yii\base\InvalidConfigException
     */
    public function getComponent(): Glide
    {
        return Yii::$app->get($this->component);
    }
    
    /**
     * {@inheritdoc}
     */
    public function beforeAction($action): bool
    {
        if (!parent::beforeAction($action)) {
            return false;
        }
        $valid = true;
        foreach ($this->getComponent()->whitelist as $paramName => $allowedValues) {
            $paramGet = Yii::$app->request->get($paramName);
            $paramBody = Yii::$app->request->getBodyParam($paramName);
            if (!in_array($paramGet, $allowedValues, true) || !in_array($paramBody, $allowedValues, true)) {
                $valid = false;
            }
        }
        if (!empty(array_diff_key(Yii::$app->request->get(), $this->whitelist))
                || !empty(array_diff_key(Yii::$app->request->getBodyParams(), $this->whitelist))) {
            $valid = false;
        }
        if (!$valid) {
            throw new BadRequestHttpException(Yii::t('yii', 'Invalid request params.'));
        } else {
            return true;
        }
    }
}
