<?php

namespace wdigital\yii2glide\components;

use yii\base\InvalidConfigException;

/**
 * Glide component
 */
class Glide extends trntv\glide\components\Glide
{
    /**
     * @var array
     */
    public $whitelist;
    
    /**
     * {@inheritdoc}
     * @throws InvalidConfigException
     */
    public function init(): void
    {
        if (!is_array($this->whitelist)) {
            throw new InvalidConfigException('Glide package whitelist of allowed params must be defined');
        }
        //convert to string to allow using int in config, because controller uses ===
        foreach (['w', 'h'] as $key) {
            if (isset($this->whitelist[$key])) {
                $this->whitelist[$key] = array_map(function ($value): string {
                    return (string) $value;
                }, $this->whitelist[$key]);
            }
        }
        parent::init();
    }
}
