<?php

namespace wdigital\yii2glide;

use Yii;
use yii\web\BadRequestHttpException;

class GlideController extends \trntv\glide\controllers\GlideController
{
    private function isSecureIntParam($param): bool
    {
        return $param === null || ((string) (int) $param) === $param;
    }
    
    private function isSecureFitParam($param): bool
    {
        return $param === null || preg_match('/^[a-zA-Z]*$/', $param) === 1;
    }
    
    public function beforeAction($action): bool
    {
        if (!parent::beforeAction($action)) {
            return false;
        }
        
        $widthGet = Yii::$app->request->get('w');
        $widthBody = Yii::$app->request->getBodyParam('w');
        $heightGet = Yii::$app->request->get('h');
        $heightBody = Yii::$app->request->getBodyParam('h');
        $fitGet = Yii::$app->request->get('fit');
        $fitBody = Yii::$app->request->getBodyParam('fit');
        
        if (!$this->isSecureIntParam($widthGet) || !$this->isSecureIntParam($widthBody)
                || !$this->isSecureIntParam($heightGet) || !$this->isSecureIntParam($heightBody)
                || !$this->isSecureFitParam($fitGet) || !$this->isSecureFitParam($fitBody)) {
            throw new BadRequestHttpException(Yii::t('yii', 'Invalid request params.'));
        } else {
            return true;
        }
    }
}
