if (typeof alexantr === 'undefined' || !alexantr) {
    var alexantr = {};
}

alexantr.coordinatesWidget = (function (d) {
    'use strict';

    var yandexMapsApiLoading = false,
        googleMapsApiLoading = false,
        yandexMapsCallbacks = [],
        googleMapsCallbacks = [],
        markers = [],
        markersId = 0,
        globalInput = null;

    function addToLocationList(marker) {
        var list = d.querySelector(`.${globalInput.id}-list`);
        var listRow = document.createElement("div");

        var deleteButton = document.createElement("a");
        deleteButton.className = "btn btn-danger btn-xs sweetalert-warning";

        var icon = document.createElement("i");
        icon.className = "fa fa-trash";
        deleteButton.onclick = function (e) {
            if (confirm('Vai izdzēst koordinātes?')) {
                removeMarkerFromList(marker.store_id);
                marker.setMap(null);
                this.remove();
            }
        };

        deleteButton.appendChild(icon);
        listRow.appendChild(deleteButton);

        let location = marker.position.lat().toFixed(6) + ', ' + marker.position.lng().toFixed(6);
        var locationText = document.createTextNode(location);
        listRow.appendChild(locationText);
        list.appendChild(listRow);
    }

    function addMarkerToMap(map, latLng) {
        let marker = new google.maps.Marker({
            draggable: true,
            position: latLng,
            map: map,
            store_id: markersId++,
        });
        function handleMarkerEvent(event) {
            changeInputValueMultipleLatLng(globalInput, markers);
        }
        addToLocationList(marker);
        marker.addListener('dragend', handleMarkerEvent);
        marker.addListener('rightclick', function(e) {
            if (confirm('Vai izdzēst koordinātes?')) {
                removeMarkerFromList(marker.store_id);
                this.setMap(null);
            }
        });
        markers.push(marker);
        changeInputValueMultipleLatLng(globalInput, markers);
    }

    function initOptions(inputId, options) {
        globalInput = d.getElementById(inputId);
        var inputValue = d.getElementById(inputId).value;
        var lat = 0, lng = 0, zoom = 1, showMarker = false;

        if (inputValue) {
            var inputLatLng = inputValue.split(/\s*,\s*/);
            if (inputLatLng.length === 2) {
                lat = parseFloat(inputLatLng[0]) || 0;
                lng = parseFloat(inputLatLng[1]) || 0;
                showMarker = true;
                zoom = 14;
            }
        }
        // no input value
        if (!showMarker) {
            if ('lat' in options && 'lng' in options) {
                lat = options.lat;
                lng = options.lng;
                zoom = ('zoom' in options) ? options.zoom : 10;
            }
        }
        return {
            lat: lat,
            lng: lng,
            zoom: zoom,
            showMarker: showMarker
        };
    }

    function changeInputValue(input, lat, lng) {
        input.value = lat.toFixed(6) + ', ' + lng.toFixed(6);
        input.setAttribute('data-changed', '1'); // prevent change event
        if ('createEvent' in d) {
            var evt = d.createEvent('HTMLEvents');
            evt.initEvent('change', false, true);
            input.dispatchEvent(evt);
        } else {
            input.fireEvent('onchange');
        }
    }

    function removeMarkerFromList(store_id) {
        markers.forEach(function(marker, index, object) {
            if (marker.store_id === store_id) {
                object.splice(index, 1);
            }
        });
        changeInputValueMultipleLatLng(globalInput, markers)
    }

    function changeInputValueMultipleLatLng(input, markers) {
        var latLng = [];
        var list = d.querySelector(`.${globalInput.id}-list`);
        while (list.firstChild) {
            list.removeChild(list.lastChild);
        }

        markers.forEach(function(marker) {
            let location = marker.position.lat().toFixed(6) + ', ' + marker.position.lng().toFixed(6);
            latLng.push(location);
            addToLocationList(marker);
        });
        input.value = JSON.stringify(latLng);
        input.setAttribute('data-changed', '1'); // prevent change event
        if ('createEvent' in d) {
            var evt = d.createEvent('HTMLEvents');
            evt.initEvent('change', false, true);
            input.dispatchEvent(evt);
        } else {
            input.fireEvent('onchange');
        }
    }

    function runYandexMaps(inputId, mapId, options) {
        var input = d.getElementById(inputId),
            opt = initOptions(inputId, options),
            placemarkPreset = 'islands#redDotIcon';
        var yMap = new ymaps.Map(mapId, {
            center: [opt.lat, opt.lng],
            zoom: opt.zoom,
            controls: ['smallMapDefaultSet']
        });
        var marker;
        if (opt.showMarker) {
            marker = new ymaps.Placemark([opt.lat, opt.lng], {}, {preset: placemarkPreset});
            yMap.geoObjects.add(marker);
        }
        yMap.events.add('click', function (e) {
            var coords = e.get('coords');
            if (typeof marker !== 'undefined') {
                yMap.geoObjects.remove(marker);
            }
            marker = new ymaps.Placemark(coords, {}, {preset: placemarkPreset});
            yMap.geoObjects.add(marker);
            changeInputValue(input, coords[0], coords[1]);
        });
        input.onchange = function () {
            if (input.getAttribute('data-changed')) {
                input.removeAttribute('data-changed');
            } else if (input.value) {
                var inputLatLng = input.value.split(/\s*,\s*/);
                if (inputLatLng.length === 2) {
                    var lat = parseFloat(inputLatLng[0]) || 0;
                    var lng = parseFloat(inputLatLng[1]) || 0;
                    yMap.setCenter([lat, lng], 14);
                    if (typeof marker !== 'undefined') {
                        yMap.geoObjects.remove(marker);
                    }
                    marker = new ymaps.Placemark([lat, lng], {}, {preset: placemarkPreset});
                    yMap.geoObjects.add(marker);
                }
            }
        };

        // workaround for blank map in some cases
        setTimeout(function () {
            yMap.container.fitToViewport();
        }, 200);
    }

    function runGoogleMaps(inputId, mapId, options) {
        var input = d.getElementById(inputId),
            map = d.getElementById(mapId),
            opt = initOptions(inputId, options);
        var latlng = new google.maps.LatLng(opt.lat, opt.lng);
        var gMap = new google.maps.Map(map, {
            zoom: opt.zoom,
            center: latlng
        });

        var list = d.querySelector(`.${globalInput.id}-list`);
        while (list.firstChild) {
            list.removeChild(list.lastChild);
        }

        var inputMarkers = [];
        try {
            inputMarkers = JSON.parse(input.value);
        } catch (e) {
        }
        inputMarkers.forEach(function (el) {
            var inputLatLng = el.split(/\s*,\s*/);
            if (inputLatLng.length === 2) {
                let latLng = new google.maps.LatLng(
                    parseFloat(inputLatLng[0]) || 0,
                    parseFloat(inputLatLng[1]) || 0
                );
                addMarkerToMap(gMap, latLng);
            }
        });

        google.maps.event.addListener(gMap, "click", (event) => {
            addMarkerToMap(gMap, event.latLng);
        });

        google.maps.event.addListener(gMap, 'click', function (e) {
            if (typeof marker !== 'undefined') {
                marker.setMap(null);
            }
            changeInputValueMultipleLatLng(input, markers);
        });
        input.onchange = function () {
            if (input.getAttribute('data-changed')) {
                input.removeAttribute('data-changed');
            } else if (input.value) {
                var inputLatLng = input.value.split(/\s*,\s*/);
                if (inputLatLng.length === 2) {
                    var lat = parseFloat(inputLatLng[0]) || 0;
                    var lng = parseFloat(inputLatLng[1]) || 0;
                    var latlng = new google.maps.LatLng(lat, lng);
                    gMap.panTo(latlng);
                    gMap.setZoom(14);
                    if (typeof marker !== 'undefined') {
                        marker.setMap(null);
                    }
                    marker = new google.maps.Marker({position: latlng, map: gMap});
                }
            }
        };

        // workaround for blank map in some cases
        setTimeout(function () {
            google.maps.event.trigger(gMap, 'resize');
        }, 200);
    }

    return {
        yandexMapsApiCallback: function () {
            yandexMapsApiLoading = false;
            for (var i = 0; i < yandexMapsCallbacks.length; i++) {
                runYandexMaps(yandexMapsCallbacks[i].inputId, yandexMapsCallbacks[i].mapId, yandexMapsCallbacks[i].options);
            }
        },
        googleMapsApiCallback: function () {
            googleMapsApiLoading = false;
            for (var i = 0; i < googleMapsCallbacks.length; i++) {
                runGoogleMaps(googleMapsCallbacks[i].inputId, googleMapsCallbacks[i].mapId, googleMapsCallbacks[i].options);
            }
        },
        initYandexMaps: function (inputId, mapId, options, lang) {
            if (typeof ymaps !== 'undefined') {
                runYandexMaps(inputId, mapId, options);
            } else {
                yandexMapsCallbacks.push({inputId: inputId, mapId: mapId, options: options});
                if (!yandexMapsApiLoading) {
                    yandexMapsApiLoading = true;
                    var script = d.createElement('script');
                    script.type = 'text/javascript';
                    script.src = 'https://api-maps.yandex.ru/2.1/?lang=' + lang + '&onload=alexantr.coordinatesWidget.yandexMapsApiCallback';
                    script.async = true;
                    var scriptTag = d.getElementsByTagName('script')[0];
                    scriptTag.parentNode.insertBefore(script, scriptTag);
                }
            }
        },
        initGoogleMaps: function (inputId, mapId, options, apiKey) {
            if (typeof google === 'object' && typeof google.maps === 'object') {
                runGoogleMaps(inputId, mapId, options);
            } else {
                googleMapsCallbacks.push({inputId: inputId, mapId: mapId, options: options});
                if (!googleMapsApiLoading) {
                    googleMapsApiLoading = true;
                    var script = d.createElement('script');
                    script.type = 'text/javascript';
                    script.src = 'https://maps.googleapis.com/maps/api/js?key=' + apiKey + '&callback=alexantr.coordinatesWidget.googleMapsApiCallback';
                    script.async = true;
                    var scriptTag = d.getElementsByTagName('script')[0];
                    scriptTag.parentNode.insertBefore(script, scriptTag);
                }
            }
        }
    };
})(document);
