<?php

namespace wdigital\coordinates;

use yii\helpers\Html;
use yii\helpers\Json;
use yii\web\View;

class MultipleCoordinatesInput extends CoordinatesInput
{
    /**
     * Registers map scripts
     */
    protected function registerClientScript()
    {
        $view = $this->getView();
        $bundle = MultipleCoordinatesAsset::register($view);

        $id = $this->options['id'];
        $mapId = $this->mapOptions['id'];

        $options = $this->getInitialOptions($bundle);
        $encodedOptions = !empty($options) ? Json::htmlEncode($options) : '{}';

        if ($this->yandexMaps) {
            $lang = $this->getYandexMapsLanguage($bundle);
            $view->registerJs("alexantr.coordinatesWidget.initYandexMaps('$id', '$mapId', $encodedOptions, '$lang');", View::POS_END);
        } else {
            $view->registerJs("alexantr.coordinatesWidget.initGoogleMaps('$id', '$mapId', $encodedOptions, '{$bundle->googleMapsApiKey}');", View::POS_END);
        }
    }

    protected function renderContent()
    {
        if ($this->hasModel()) {
            $content = Html::activeTextInput($this->model, $this->attribute, $this->options) . "\n";
        } else {
            $content = Html::textInput($this->name, $this->value, $this->options) . "\n";
        }
        $content .= Html::tag('div', '', $this->mapOptions);
        $content .= Html::tag('label', 'Koordināšu saraksts', ['class' => 'control-label']);
        $content .= Html::tag('div', '', ['class' => "{$this->options['id']}-list"]);
        return $content;
    }
}
