<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var yii\widgets\ActiveForm $form
 * @var wdigital\users\models\RecoveryForm $model
 * @var wdigital\users\Module $module
 * @var string $title
 */

$this->title = $title . ' | ' . Yii::$app->name;
?>
<?= $this->render('/_alert', ['module' => Yii::$app->getModule('user')]) ?>
<div class="middle-box text-center loginscreen animated fadeInDown">
    <div>
        <?php if ($module->loginLogo !== null): ?>
            <div>
                <h1 class="logo-name bottom-padding--20 top-padding--100">
                    <a href="<?= Url::toRoute(['/'])?>">
                        <img src="<?= $module->loginLogo ?>" alt="" style="width: 180px; height: auto">
                    </a>
                </h1>
            </div>
        <?php endif; ?>
        <h3><?= Html::encode($this->title) ?></h3>
        <?php $form = ActiveForm::begin(['enableClientValidation' => false]); ?>
        <?= $form->field($model, 'password')->passwordInput() ?>
        <?= $form->field($model, 'password_repeat')->passwordInput() ?>
        <?= Html::submitButton(Yii::t('user', 'Finish'), ['class' => 'btn btn-primary btn-block']) ?><br>
        <?php ActiveForm::end(); ?>
    </div>
</div>
