<?php

use wdigital\users\models\RbacItemSearch;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\Url;
use yii\web\View;
use yii\widgets\Pjax;

/**
 * @var $dataProvider array
 * @var $filterModel RbacItemSearch
 * @var $this View
 */

$this->title = Yii::t('user', 'Permissions');
$this->params['breadcrumbs'][] = $this->title;

?>

<?= $this->render('/_alert', ['module' => Yii::$app->getModule('user')]) ?>

<?= $this->render('/admin/_menu', ['module' => Yii::$app->getModule('user')]) ?>

<?php Pjax::begin() ?>

<?= GridView::widget([
    'dataProvider' => $dataProvider,
    'filterModel' => $filterModel,
    'layout' => "{items}\n{pager}",
    'columns' => [
        [
            'attribute' => 'name',
            'label' => $filterModel->getAttributeLabel('name'),
            'options' => [
                'style' => 'width: 20%'
            ],
        ],
        [
            'attribute' => 'description',
            'label' => $filterModel->getAttributeLabel('description'),
            'options' => [
                'style' => 'width: 55%',
            ],
        ],
        [
            'attribute' => 'rule_name',
            'label' => $filterModel->getAttributeLabel('rule_name'),
            'options' => [
                'style' => 'width: 20%'
            ],

        ],
        [
            'class' => ActionColumn::class,
            'template' => '{update} {delete}',
            'urlCreator' => static fn (string $action, $model) => Url::to(['/user/permission/' . $action, 'name' => $model['name']]),
            'options' => [
                'style' => 'width: 5%'
            ],
        ]
    ],
]) ?>

<?php Pjax::end() ?>
