<?php

namespace wdigital\users\controllers;

use wdigital\users\models\RbacRoleForm;
use Yii;
use yii\rbac\Role;
use yii\web\NotFoundHttpException;

/**
 * Class RoleController
 * @package wdigital\users\controllers
 */
class RoleController extends RbacItemControllerAbstract
{
    /**
     * @inheritdoc
     */
    protected ?string $modelClass = RbacRoleForm::class;

    /**
     * @inheritdoc
     */
    protected ?int $type = Role::TYPE_ROLE;

    /**
     * @inheritdoc
     * @throws NotFoundHttpException
     */
    protected function getItem(string $name)
    {
        $role = Yii::$app->authManager->getRole($name);

        if ($role instanceof Role) {
            return $role;
        }

        throw new NotFoundHttpException();
    }
}
