<?php

namespace wdigital\users\controllers;

use wdigital\users\models\RbacPermissionForm;
use Yii;
use yii\rbac\Permission;
use yii\rbac\Role;
use yii\web\NotFoundHttpException;

/**
 * Class PermissionController
 * @package wdigital\users\controllers
 */
class PermissionController extends RbacItemControllerAbstract
{
    /**
     * @inheritdoc
     */
    protected ?string $modelClass = RbacPermissionForm::class;

    /**
     * @inheritdoc
     */
    protected ?int $type = Role::TYPE_PERMISSION;

    /**
     * @inheritdoc
     * @throws NotFoundHttpException
     */
    protected function getItem(string $name)
    {
        $role = Yii::$app->authManager->getPermission($name);

        if ($role instanceof Permission) {
            return $role;
        }

        throw new NotFoundHttpException();
    }
}
