<?php

namespace wdigital\users\traits;

use wdigital\users\Module;
use Yii;
use yii\base\InvalidConfigException;
use yii\db\Connection;

/**
 * Trait ModuleTrait
 *
 * @property-read Module $module
 * @package wdigital\users\traits
 */
trait ModuleTrait
{
    /**
     * @return Module
     * @throws InvalidConfigException
     */
    public static function getModule(): Module
    {
        $module = Yii::$app->getModule('user');
        if ($module instanceof Module) {
            return $module;
        }
        throw new InvalidConfigException("Module with id 'user' must be or inherit " . Module::class);
    }

    /**
     * @return Connection
     * @throws InvalidConfigException
     */
    public static function getDb(): Connection
    {
        return static::getModule()->getDb();
    }
}
