<?php

namespace wdigital\users;

use Yii;
use yii\base\InvalidConfigException;
use yii\base\Module as BaseModule;
use yii\db\Connection;

/**
 * This is the main module class for the Yii2-user.
 *
 * @property array $modelMap
 *
 * @author Dmitry Erofeev <dmeroff@gmail.com>
 */
class Module extends BaseModule
{
    /** Email is changed right after user enter's new email address. */
    const STRATEGY_INSECURE = 0;

    /** Email is changed after user clicks confirmation link sent to his new email address. */
    const STRATEGY_DEFAULT = 1;

    /** Email is changed after user clicks both confirmation links sent to his old and new email addresses. */
    const STRATEGY_SECURE = 2;

    /** @var bool Whether to show flash messages. */
    public $enableFlashMessages = true;

    /** @var bool Whether to enable registration. */
    public $enableRegistration = false;

    /** @var bool Whether to remove password field from registration form. */
    public $enableGeneratingPassword = true;

    /** @var bool Whether user has to confirm his account. */
    public $enableConfirmation = true;

    /** @var bool Whether to allow logging in without confirmation. */
    public $enableUnconfirmedLogin = false;

    /** @var bool Whether to enable password recovery. */
    public $enablePasswordRecovery = true;

    /** @var bool Whether user can remove his account */
    public $enableAccountDelete = false;

    /** @var bool Enable the 'impersonate as another user' function */
    public $enableImpersonateUser = true;

    /** @var int Email changing strategy. */
    public $emailChangeStrategy = self::STRATEGY_DEFAULT;

    /**
     * @var bool Whether to enable user profile information
     */
    public bool $enableUserProfile = false;

    /**
     * @var string User profile image upload folder
     */
    public string $profileImageUploadFolder = '@webroot';

    /**
     * @var bool Whether to enable user authorization via social accounts
     */
    public bool $enableUserSocialAccount = false;

    /**
     * @var string|null View layout to use for unauthenticated views if null default will be used
     */
    public ?string $unauthenticatedLayout = null;

    /**
     * @var string|null Webroot path to login logo image
     */
    public ?string $loginLogo = null;

    /**
     * @var bool Whether to enable user blocking based on incorrect login attempt threshold
     */
    public bool $enableBlockingByLoginAttempts = true;

    /**
     * @var int Incorrect login attempt threshold before the user is blocked
     */
    public int $maxLoginAttempts = 5;

    /**
     * @var bool Whether to enable blocking of administrative accounts by reaching login attempt threshold
     */
    public bool $enableLoginAttemptsForAdmins = false;

    /**
     * @var bool Whether to enable sending user blocked email notifications to administrator
     */
    public bool $enableBlockingEmailNotification = false;

    /**
     * @var bool Whether to enable managing rbac roles via user package views
     */
    public bool $enableRbacRoleManagement = false;

    /** @var int The time you want the user will be remembered without asking for credentials. */
    public $rememberFor = 1209600; // two weeks

    /** @var int The time before a confirmation token becomes invalid. */
    public $confirmWithin = 86400; // 24 hours

    /** @var int The time before a recovery token becomes invalid. */
    public $recoverWithin = 21600; // 6 hours

    /** @var int Cost parameter used by the Blowfish hash algorithm. */
    public $cost = 10;

    /** @var array An array of administrator's usernames. */
    public $admins = [];

    /** @var string The Administrator permission name. */
    public $adminPermission;

    /** @var array Mailer configuration */
    public $mailer = [];

    /** @var array Model map */
    public $modelMap = [];

    /**
     * @var string The prefix for user module URL.
     *
     * @See [[GroupUrlRule::prefix]]
     */
    public $urlPrefix = 'user';

    /** @var string The database connection to use for models in this module. */
    public $dbConnection = 'db';

    /** @var array The rules to be used in URL management. */
    public $urlRules = [
        '<id:\d+>' => 'profile/show',
        '<action:(login|logout|forgot)>' => 'security/<action>',
        'confirm/<id:\d+>/<code:[A-Za-z0-9_-]+>' => 'security/confirm',
        'recover/<id:\d+>/<code:[A-Za-z0-9_-]+>' => 'security/reset',
    ];

    /**
     * @return Connection
     * @throws InvalidConfigException
     */
    public function getDb(): Connection
    {
        $dbConnection = Yii::$app->get($this->dbConnection);
        if ($dbConnection instanceof Connection) {
            return $dbConnection;
        }
        throw new InvalidConfigException('Could not instantiate db connection for user module');
    }
}
