<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use wdigital\users\migrations\Migration;

/**
 * Class m140209_132017_create_user_and_user_profile_tables
 */
class m140209_132017_create_user_and_user_profile_tables extends Migration
{
    /**
     * @inheritDoc
     */
    public function safeUp(): bool
    {
        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey()->unsigned(),
            'email' => $this->string(255)->notNull()->unique(),
            'password_hash' => $this->string(60)->notNull(),
            'auth_key' => $this->string(32)->notNull(),
            'confirmed_at' => $this->dateTime(),
            'blocked_at' => $this->dateTime(),
            'registration_ip' => $this->string(255),
            'last_login_at' => $this->dateTime(),
            'login_attempts' => $this->tinyInteger()->unsigned()->notNull()->defaultValue(0),
            'created_at' => $this->dateTime()->notNull(),
            'updated_at' => $this->dateTime()->notNull(),
        ], $this->tableOptions);

        if ($this->module->enableUserProfile) {
            $this->createTable('{{%user_profile}}', [
                'user_id' => $this->integer()->unsigned()->notNull(),
                'title' => $this->string(255),
                'image' => $this->string(255),
                'created_at' => $this->dateTime()->notNull(),
                'updated_at' => $this->dateTime()->notNull(),
            ], $this->tableOptions);
            $this->addPrimaryKey('{{%pf_user_profile}}', '{{%user_profile}}', 'user_id');
            $this->addForeignKey('{{%fk_user_profile}}', '{{%user_profile}}', 'user_id', '{{%user}}', 'id', $this->cascade, $this->cascade);
        }
        return true;
    }

    /**
     * @inheritDoc
     */
    public function safeDown(): bool
    {
        if ($this->module->enableUserProfile) {
            $this->dropTable('{{%user_profile}}');
        }
        $this->dropTable('{{%user}}');
        return true;
    }
}
