<?php

use wdigital\users\models\AssignmentForm;
use wdigital\users\models\User;
use yii\bootstrap\Alert;
use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/**
 * @var View $this
 * @var User $user
 * @var AssignmentForm $model
 */
?>

<?php $this->beginContent('@wdigital/users/views/admin/update.php', ['user' => $user]) ?>

<?= Alert::widget([
    'options' => [
        'class' => 'alert-info alert-dismissible',
    ],
    'body' => Yii::t('user', 'You can assign multiple roles or permissions to user by using the form below'),
]) ?>

<?php $form = ActiveForm::begin(['enableClientValidation' => false]) ?>

<?= Html::activeHiddenInput($model, 'user_id') ?>

<?= $form->field($model, 'items')->dropDownList($model->retrieveAvailableItems(), ['multiple' => true]) ?>

<?= Html::submitButton(Yii::t('user', 'Update assignments'), ['class' => 'btn btn-primary btn-block']) ?>

<?php ActiveForm::end() ?>

<?php $this->endContent() ?>
