<?php

use wdigital\users\migrations\Migration;

/**
 * @author Dmitry Erofeev <dmeroff@gmail.com>
 */
class m140504_130429_create_token_table extends Migration
{
    /**
     * @inheritDoc
     */
    public function safeUp(): bool
    {
        $this->createTable('{{%token}}', [
            'user_id'    => $this->integer()->unsigned()->notNull(),
            'code'       => $this->string(32)->notNull(),
            'created_at' => $this->dateTime()->notNull(),
            'type'       => $this->smallInteger()->notNull(),
        ], $this->tableOptions);

        $this->createIndex('{{%token_unique}}', '{{%token}}', ['user_id', 'code', 'type'], true);
        $this->addForeignKey('{{%fk_user_token}}', '{{%token}}', 'user_id', '{{%user}}', 'id', $this->cascade, $this->cascade);
        return true;
    }

    /**
     * @inheritDoc
     */
    public function safeDown(): bool
    {
        $this->dropTable('{{%token}}');
        return true;
    }
}
