<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium/>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use wdigital\users\migrations\Migration;

/**
 * Class m140403_174025_create_user_social_account_table
 */
class m140403_174025_create_user_social_account_table extends Migration
{
    /**
     * @inheritDoc
     */
    public function safeUp(): bool
    {
        if ($this->module->enableUserSocialAccount) {
            $this->createTable('{{%social_account}}', [
                'id' => $this->primaryKey()->unsigned(),
                'user_id' => $this->integer()->unsigned(),
                'provider' => $this->string()->notNull(),
                'client_id' => $this->string()->notNull(),
                'data' => $this->text(),
                'code' => $this->string(32)->unique(),
                'created_at' => $this->dateTime(),
                'email' => $this->string(),
                'properties' => $this->text(),
            ], $this->tableOptions);
            $this->createIndex('{{%social_account_unique}}', '{{%social_account}}', ['provider', 'client_id'], true);
            $this->addForeignKey('{{%fk_social_account_user_id}}', '{{%social_account}}', 'user_id', '{{%user}}', 'id', $this->cascade, $this->cascade);
        }
        return true;
    }

    /**
     * @inheritDoc
     */
    public function safeDown(): bool
    {
        if ($this->module->enableUserSocialAccount) {
            $this->dropTable('{{%account}}');
        }
        return true;
    }
}
