<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var wdigital\users\models\LoginForm $model
 * @var wdigital\users\Module $module
 */

$this->title = Yii::$app->name;
?>

<?= $this->render('/_alert', ['module' => Yii::$app->getModule('user')]) ?>
<div class="middle-box text-center loginscreen animated fadeInDown">
    <div>
        <?php if ($module->loginLogo !== null): ?>
            <div>
                <h1 class="logo-name bottom-padding--20 top-padding--100">
                    <a href="<?= Url::toRoute(['/'])?>">
                        <img src="<?= $module->loginLogo ?>" alt="" style="width: 180px; height: auto">
                    </a>
                </h1>
            </div>
        <?php endif; ?>
        <h3><?= Html::encode($this->title) ?></h3>
        <?php $form = ActiveForm::begin(['enableClientValidation' => false]) ?>
        <?= $form->field($model, 'login')->textInput(['class' => 'form-control']) ?>
        <?= $form->field($model, 'password')->passwordInput(['class' => 'form-control']) ?>
        <?= Html::submitButton(Yii::t('user', 'Sign in'), ['class' => 'btn btn-primary btn-block', 'tabindex' => '4']) ?>
        <?php ActiveForm::end(); ?>
        <?php if ($module->enablePasswordRecovery): ?>
            <p class="m-t text-center">
                <?= Html::a(Yii::t('user', 'Forgot password?'), ['/user/forgot']) ?>
            </p>
        <?php endif ?>
    </div>
</div>
