<?php

use wdigital\users\models\User;
use wdigital\users\models\UserSearch;
use wdigital\users\Module;
use yii\data\ActiveDataProvider;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\Html;
use yii\web\View;
use yii\widgets\Pjax;


/**
 * @var View $this
 * @var ActiveDataProvider $dataProvider
 * @var UserSearch $searchModel
 * @var Module $module
 */

$this->title = Yii::t('user', 'Manage users');
$this->params['breadcrumbs'][] = $this->title;
?>

<?= $this->render('/_alert', ['module' => Yii::$app->getModule('user')]) ?>

<?= $this->render('/admin/_menu', ['module' => Yii::$app->getModule('user')]) ?>

<?php Pjax::begin() ?>

<?= GridView::widget([
    'dataProvider' => $dataProvider,
    'filterModel' => $searchModel,
    'layout' => "{items}\n{pager}",
    'columns' => [
        'email:email',
        'registration_ip',
        'created_at:datetime',
        'last_login_at:datetime',
        'confirmed_at:datetime',
        'blocked_at:datetime',
        [
            'header' => Yii::t('user', 'Confirmation'),
            'value' => static function (User $model) {
                if ($model->getIsConfirmed()) {
                    return Html::tag(
                        'div',
                        Html::tag('span', Yii::t('user', 'Confirmed'), ['class' => 'text-success']),
                        ['class' => 'text-center']
                    );
                }
                return Html::a(Yii::t('user', 'Confirm'), ['confirm', 'id' => $model->id], [
                    'class' => 'btn btn-xs btn-success btn-block',
                    'data-method' => 'post',
                    'data-confirm' => Yii::t('user', 'Are you sure you want to confirm this user?'),
                ]);
            },
            'format' => 'raw',
            'visible' => $module->enableConfirmation,
        ],
        [
            'header' => Yii::t('user', 'Block status'),
            'value' => static function (User $model) {
                if ($model->getIsBlocked()) {
                    return Html::a(Yii::t('user', 'Unblock'), ['block', 'id' => $model->id], [
                        'class' => 'btn btn-xs btn-success btn-block',
                        'data-method' => 'post',
                        'data-confirm' => Yii::t('user', 'Are you sure you want to unblock this user?'),
                    ]);
                }
                return Html::a(Yii::t('user', 'Block'), ['block', 'id' => $model->id], [
                    'class' => 'btn btn-xs btn-danger btn-block',
                    'data-method' => 'post',
                    'data-confirm' => Yii::t('user', 'Are you sure you want to block this user?'),
                ]);
            },
            'format' => 'raw',
        ],
        [
            'class' => ActionColumn::class,
            'template' => '{switch} {update} {delete}',
            'buttons' => [
                'switch' => static fn($url, User $model) => Html::a('<span class="glyphicon glyphicon-user"></span>', ['/user/admin/switch', 'id' => $model->id], [
                    'title' => Yii::t('user', 'Become this user'),
                    'data-confirm' => Yii::t('user', 'Are you sure you want to switch to this user for the rest of this Session?'),
                    'data-method' => 'POST',
                ]),
            ],
            'visibleButtons' => [
                'switch' => static fn(User $model) => Yii::$app->user->identity->isAdmin && $model->id !== Yii::$app->user->id && $module->enableImpersonateUser,
            ]
        ],
    ],
]); ?>

<?php Pjax::end() ?>
