<?php

use wdigital\users\Module;
use yii\bootstrap\Nav;

/**
 * @var Module $module
 */
?>

<?= Nav::widget([
    'options' => [
        'class' => 'nav-tabs',
        'style' => 'margin-bottom: 15px',
    ],
    'items' => [
        [
            'label' => Yii::t('user', 'Users'),
            'url' => ['/user/admin/index'],
        ],
        [
            'label' => Yii::t('user', 'Roles'),
            'url' => ['/user/role/index'],
            'visible' => $module->enableRbacRoleManagement,
        ],
        [
            'label' => Yii::t('user', 'Permissions'),
            'url' => ['/user/permission/index'],
            'visible' => $module->enableRbacRoleManagement,
        ],
        [
            'label' => Yii::t('user', 'Rules'),
            'url' => ['/user/rule/index'],
            'visible' => $module->enableRbacRoleManagement,
        ],
        [
            'label' => Yii::t('user', 'Create'),
            'items' => [
                [
                    'label' => Yii::t('user', 'New user'),
                    'url' => ['/user/admin/create'],
                ],
                [
                    'label' => Yii::t('user', 'New role'),
                    'url' => ['/user/role/create'],
                    'visible' => $module->enableRbacRoleManagement,
                ],
                [
                    'label' => Yii::t('user', 'New permission'),
                    'url' => ['/user/permission/create'],
                    'visible' => $module->enableRbacRoleManagement,
                ],
                [
                    'label' => Yii::t('user', 'New rule'),
                    'url' => ['/user/rule/create'],
                    'visible' => $module->enableRbacRoleManagement,
                ]
            ],
        ],
    ],
]) ?>
