<?php

namespace wdigital\users\validators;

use Yii;
use yii\rbac\ManagerInterface;
use yii\validators\Validator;

class RbacValidator extends Validator
{
    /**
     * @var ManagerInterface
     */
    protected ManagerInterface $manager;

    /**
     * @inheritdoc
     */
    public function init(): void
    {
        parent::init();
        $this->manager = Yii::$app->authManager;
    }

    /**
     * @inheritdoc
     */
    protected function validateValue($value): ?array
    {
        if (!is_array($value)) {
            return [Yii::t('user', 'Invalid value'), []];
        }

        foreach ($value as $val) {
            if ($this->manager->getRole($val) === null && $this->manager->getPermission($val) === null) {
                return [Yii::t('user', 'There is neither role or permission with name "{0}"', [$val]), []];
            }
        }
        return null;
    }
}
