<?php

namespace wdigital\users\models;

use wdigital\users\validators\RbacValidator;
use Yii;
use yii\base\InvalidArgumentException;
use yii\base\Model;
use yii\helpers\Json;
use yii\rbac\DbManager;

class AuthItem extends Model
{
    /**
     * @var string|null
     */
    public ?string $name = null;

    /**
     * @var int|null
     */
    public ?int $type = null;

    /**
     * @var string|null
     */
    public ?string $description = null;

    /**
     * @var string|null
     */
    public ?string $rule_name = null;

    /**
     * @var mixed|null
     */
    public $data = null;

    /**
     * @var DbManager
     */
    protected DbManager $manager;

    /**
     * @inheritDoc
     */
    public function init(): void
    {
        parent::init();
        $this->manager = Yii::$app->authManager;
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'name' => Yii::t('user', 'Auth item name'),
            'type' => Yii::t('user', 'Type'),
            'description' => Yii::t('user', 'Description'),
            'rule_name' => Yii::t('user', 'Rule'),
            'data' => Yii::t('user', 'Data'),
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['name'], 'required'],
            [['name', 'description', 'rule_name'], 'trim'],
            [['name'], 'unique'],
            [['children'], RbacValidator::class],
//            [['rule'], 'exist', 'targetAttribute' => 'name', 'filter' => ['type' => $this->]],
            ['data', function () {
                try {
                    Json::decode($this->data);
                } catch (InvalidArgumentException $e) {
                    $this->addError('data', Yii::t('user', 'Data must be type of JSON ({0})', $e->getMessage()));
                }
            }],
        ];
    }
}
