<?php

namespace wdigital\users\controllers;



/**
 * Class PermissionController
 * @package wdigital\users\controllers
 */
class PermissionController extends RbacItemControllerAbstract
{
    /**
     * @inheritdoc
     */
    protected ?string $modelClass = RbacRoleForm::class;

    /**
     * @inheritdoc
     */
    protected ?int $type = Role::TYPE_PERMISSION;

    /**
     * @inheritdoc
     * @throws NotFoundHttpException
     */
    protected function getItem(string $name)
    {
        $role = Yii::$app->authManager->getRole($name);

        if ($role instanceof Role) {
            return $role;
        }

        throw new NotFoundHttpException();
    }
}
