<?php

namespace wdigital\cms\user\migrations; // because it can be overidden via mapping

use dektrium\user\Finder;
use dektrium\user\models\User as MappedUser;
use wdigital\cms\user\models\User;
use Yii;
use yii\db\Migration;

/**
 * Handles the creation of the initial admin user.
 */
class m171114_005617_add_admin_user extends Migration
{
    const EMAIL = 'admin@whitedigital.eu';
    const NAME = 'Administrator';
    const PASSWORD = 'adminadmin';
    const USERNAME = 'admin';

    /**
     * @var Finder
     */
    protected $finder;

    /**
     * @param Finder $finder
     * @param array $config
     */
    public function __construct(Finder $finder, $config = [])
    {
        $this->finder = $finder;
        parent::__construct($config);
    }

    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        /* @var $user User */
        $user = Yii::createObject([
                'class' => MappedUser::class,
                'username' => self::USERNAME,
                'email' => self::EMAIL,
                'password' => self::PASSWORD,
        ]);

        $user->create();

        $user->profile->name = self::NAME;
        $user->profile->save();
    }

    /**
     * @inheritdoc
     */
    public function safeDown()
    {
        $user = $this->finder
            ->findUser(['or', ['username' => self::USERNAME, 'email' => self::EMAIL]])
            ->one();
        if ($user) {
            $user->delete();
        } else {
            echo "Did not remove admin user as it would not clash with a new one since neither username nor email matches.\n";
        }
    }

}
