<?php

namespace wdigital\cms\user\models;

use dektrium\user\models\User as Model;
use wdigital\cms\user\Module;
use Yii;

/**
 * @property-read Module $module
 */
class User extends Model
{
    const SCENARIO_REGISTER = 'register';
    const SCENARIO_CONNECT = 'connect';
    const SCENARIO_CREATE = 'create';
    const SCENARIO_UPDATE = 'update';
    const SCENARIO_SETTINGS = 'settings';

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $rules = parent::rules();

        if (!$this->module->enableUsernames) {
            unset($rules['usernameRequired'], $rules['usernameMatch']);
            $rules = [
                'usernameDefault' => [
                    'username', 'default', 'value' => function($model) {
                        return $model->email;
                    },
                ],
            ] + $rules;
        }

        return $rules;
    }
}
