<?php

namespace wdigital\cms\user\models;

use dektrium\user\models\RecoveryForm as Model;
use dektrium\user\traits\ModuleTrait;
use wdigital\cms\user\Module;
use Yii;

/**
 * @property-read Module $module
 */
class RecoveryForm extends Model
{

    use ModuleTrait;
    /**
     * Repeat password field to verify that the user can replicate their new password.
     * @var string
     */
    public $repeatPassword;

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        $scenarios = parent::scenarios();

        if ($this->module->repeatPasswordPrompt) {
            $scenarios[self::SCENARIO_RESET][] = 'repeatPassword';
        }

        return $scenarios;
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $rules = parent::rules();

        if ($this->module->repeatPasswordPrompt) {
            $rules += [
                'repeatPasswordCompare' => ['repeatPassword', 'compare', 'compareAttribute' => 'password', 'skipOnEmpty' => false],
                'repeatPasswordRequired' => ['repeatPassword', 'required'],
            ];
        }

        return $rules;
    }

    /** @inheritdoc */
    public function attributeLabels()
    {
        return parent::attributeLabels() + [
            'repeatPassword' => Yii::t('user', 'Repeat password'),
        ];
    }
}
