# White Digital CMS User Management Module

The CMS user management module. Builds upon [`dektrium/user`] with adjustments specific to WD CMS.


## Installation

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-user:^0.1.0

or add

    "wdigital/cms-user": "^0.1.0"

to the `require` section of your `composer.json` file.


### 2. Configure

If you have separate instances for frontend and backend applications (the Yii2 Advanced Application template), you have
to follow [this guide][app-advanced-guide], substituting `dektrium\user\Module` for `wdigital\cms\user\Module`. If you
depend on `\yii\filters\AccessControl`, you may also want to configure the `user` component as outlined below, instead
of removing (commenting) its configuration altogether.

#### 2.1. Module

    'modules' => [
        // ...
        'user' => wdigital\cms\user\Module::class,
    ],

#### 2.2. Component

Although the module provides a bootstrap class with the purpose of being bootstrapped before any application components
thus avoiding a collision between the application's `user` component and the `user` module, `\yii\filters\AccessControl`
will require the `user` component to be initialized before the module has had a chance of configuring it. Therefore, you
may have to explicitly configure the `user` component as follows:

    'components' => [
        // ...
        'user' => [
            'identityClass' => wdigital\cms\user\models\User::class,
            'loginUrl' => ['/user/security/login'],
            'enableAutoLogin' => true,
        ],
    ],


### 3. Migrate

    $ php yii migrate

[`dektrium/user`]: https://github.com/dektrium/yii2-user
[composer]: http://getcomposer.org/download/
[app-advanced-guide]: https://github.com/dektrium/yii2-user/blob/0.9.12/docs/usage-with-advanced-template.md
