<?php

namespace wdigital\cms\user\models;

use dektrium\user\models\SettingsForm as Model;
use wdigital\cms\user\Module;
use Yii;
use yii\helpers\ArrayHelper;

/**
 * @property-read Module $module
 */
class SettingsForm extends Model
{
    /**
     * Repeat password field to verify that the user can replicate their new password.
     * @var string
     */
    public $repeatPassword;

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        $scenarios = parent::scenarios();

        if (!$this->module->enableUsernames) {
            foreach ($scenarios as &$attributes) {
                ArrayHelper::removeValue($attributes, 'username');
                $attributes[] = '!username';
            }
        }

        return $scenarios;
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $rules = parent::rules();

        if (!$this->module->enableUsernames) {
            unset($rules['usernameRequired'], $rules['usernameMatch']);
        }

        if ($this->module->repeatPasswordPrompt) {
            $rules += [
                'repeatPasswordCompare' => ['repeatPassword', 'compare', 'compareAttribute' => 'new_password', 'skipOnEmpty' => false],
            ];
        }

        return $rules;
    }

    /** @inheritdoc */
    public function attributeLabels()
    {
        return parent::attributeLabels() + [
            'repeatPassword' => Yii::t('user', 'Repeat password'),
        ];
    }
}
