<?php

namespace wdigital\cms\user\models;

use dektrium\user\models\LoginForm as BaseLoginForm;
use wdigital\cms\user\Module;
use yii\base\ModelEvent;

/**
 * @property-read Module $module
 */
class LoginForm extends BaseLoginForm
{
    /**
     * @inheritdoc
     *
     * Works around the parent method.
     */
    public function beforeValidate()
    {
        $event = new ModelEvent();
        $this->trigger(self::EVENT_BEFORE_VALIDATE, $event);

        if (!$event->isValid) {
            return false;
        }

        $login = trim($this->login);
        $this->user = $this->module->enableUsernames
            ? $this->finder->findUserByUsernameOrEmail($login)
            : $this->finder->findUserByEmail($login);

        return true;
    }
}
