<?php

namespace wdigital\cms\user\models;

use dektrium\user\models\User as Model;
use wdigital\cms\user\Module;
use Yii;

/**
 * @property-read Module $module
 */
class User extends Model
{
    const SCENARIO_REGISTER = 'register';
    const SCENARIO_CONNECT = 'connect';
    const SCENARIO_CREATE = 'create';
    const SCENARIO_UPDATE = 'update';
    const SCENARIO_SETTINGS = 'settings';

    /**
     * Repeat password field to verify that the user can replicate their new password.
     * @var string
     */
    public $repeatPassword;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $rules = parent::rules();

        if ($this->module->repeatPasswordPrompt) {
            $rules += [
                'repeatPasswordCompare' => [
                    'repeatPassword', 'compare', 'compareAttribute' => 'password', 'skipOnEmpty' => false,
                    'except' => static::SCENARIO_REGISTER,
                ],
                'repeatPasswordRequiredOnReg' => [
                    'repeatPassword', 'required', 'skipOnEmpty' => $this->module->enableGeneratingPassword,
                    'on' => static::SCENARIO_REGISTER,
                ],
                'repeatPasswordCompareOnReg' => [
                    'repeatPassword', 'compare', 'compareAttribute' => 'password', 'skipOnEmpty' => $this->module->enableGeneratingPassword,
                    'on' => static::SCENARIO_REGISTER,
                ],
            ];
        }

        return $rules;
    }

    /** @inheritdoc */
    public function attributeLabels()
    {
        return parent::attributeLabels() + [
            'repeatPassword' => Yii::t('user', 'Repeat password'),
        ];
    }
}
