# White Digital CMS User Management Module

The CMS user management module. Builds upon [`dektrium/user`] with adjustments specific to WD CMS.


## Installation

### 1. Download

The preferred way to install this module is via [composer].

First, add the White Digital Composer repository to your `composer.json`:

    "repositories": [{
        "type": "composer",
        "url": "https://composer.wdigital.lv"
    }]

After that, either run

    $ composer require wdigital/cms-user:^0.1.0

or add

    "wdigital/cms-user": "^0.1.0"

to the `require` section of your `composer.json` file.


### 2. Configure

> IMPORTANT! Ensure that your application does not have a `user` component configured beforehand.

    'modules' => [
        // ...
        'user' => [
            'class' => \wdigital\cms\user\Module::class,
        ],
    ],

If you have separate instances for frontend and backend applications (the Yii2 Advanced Application template), you have
to follow [this guide][app-advanced-guide], substituting `dektrium\user\Module` for `wdigital\cms\user\Module`.

### 3. Migrate

    $ php yii migrate

[`dektrium/user`]: https://github.com/dektrium/yii2-user
[composer]: http://getcomposer.org/download/
[app-advanced-guide]: https://github.com/dektrium/yii2-user/blob/0.9.12/docs/usage-with-advanced-template.md
