<?php

namespace wdigital\cms\user\models;

use dektrium\user\models\SettingsForm as Model;
use wdigital\cms\user\Module;
use Yii;

/**
 * @property-read Module $module
 */
class SettingsForm extends Model
{
    /**
     * Repeat password field to verify that the user can replicate their new password.
     * @var string
     */
    public $repeatPassword;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $rules = parent::rules();

        if ($this->module->repeatPasswordPrompt) {
            $rules += [
                'repeatPasswordCompare' => ['repeatPassword', 'compare', 'compareAttribute' => 'new_password', 'skipOnEmpty' => false],
            ];
        }

        return $rules;
    }

    /** @inheritdoc */
    public function attributeLabels()
    {
        return parent::attributeLabels() + [
            'repeatPassword' => Yii::t('user', 'Repeat password'),
        ];
    }
}
