<?php

namespace wdigital\cms\user\models;

use dektrium\user\models\RegistrationForm as Model;
use dektrium\user\models\User;
use wdigital\cms\user\Module;
use Yii;

/**
 * @property-read Module $module
 */
class RegistrationForm extends Model
{
    /**
     * Repeat password field to verify that the user can replicate their new password.
     * @var string
     */
    public $repeatPassword;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        $rules = parent::rules();

        if ($this->module->repeatPasswordPrompt) {
            $rules += [
                'repeatPasswordCompare' => ['repeatPassword', 'compare', 'compareAttribute' => 'password', 'skipOnEmpty' => false],
                'repeatPasswordRequired' => ['repeatPassword', 'required', 'skipOnEmpty' => $this->module->enableGeneratingPassword],
            ];
        }

        return $rules;
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return parent::attributeLabels() + [
            'repeatPassword' => Yii::t('user', 'Repeat password'),
        ];
    }

    /**
     * @inheritdoc
     */
    protected function loadAttributes(User $user)
    {
        $attributes = $this->attributes;
        unset($attributes['repeatPassword']);
        $user->setAttributes($attributes);
    }
}
