<?php

namespace wdigital\cms\siteTree\widgets;

use wdigital\cms\siteTree\assets\SiteTreeAsset;
use yii\base\InvalidConfigException;
use yii\base\Widget;
use yii\helpers\Json;
use yii\helpers\Url;

/**
 * Class Menu
 * Theme menu widget.
 */
class SiteTreeWidget extends Widget
{
    public string|null $queryUrl;

    public string|array|null $enabledButtons = null;

    public string|null $siteTreeId = null;

    public string|null $controller = null;

    /**
     * {@inheritdoc}
     * @throws InvalidConfigException
     */
    public function init(): void
    {
        parent::init();
        if ($this->siteTreeId === null) {
            $this->siteTreeId = 'jstree';
        }
        if ($this->queryUrl === null) {
            $this->queryUrl = Url::to(['ajax/get-site-tree-data']);
        }
        if ($this->controller === null) {
            $this->controller = 'site-tree/default';
        }
        if ($this->enabledButtons === null) {
            $this->enabledButtons = Json::encode([
                'addChild' => true,
                'delete' => true,
                'copyLink' => true,
                'edit' => true,
            ]);
        } elseif (is_array($this->enabledButtons)) {
            $this->enabledButtons = Json::encode($this->enabledButtons);
        } else {
            throw new InvalidConfigException('enabledButtons option should be an array!');
        }
    }

    /**
     * {@inheritdoc}
     */
    public function run()
    {
        echo "<div id=\"$this->siteTreeId\"></div>";

        $this->registerPlugin();
    }

    /**
     * Registers necessary assets for site tree widget
     */
    protected function registerPlugin(): void
    {
        $js = [];

        $view = $this->getView();

        SiteTreeAsset::register($view);

        $js[] = "createSiteTreeObjectConfig('$this->siteTreeId', '$this->queryUrl', '$this->enabledButtons', '$this->controller')";

        $view->registerJs(implode("\n", $js));
    }
}
