<?php

namespace wdigital\cms\siteTree\migrations\multiple;

use yii\db\Migration;

/**
 * Handles the creation of table `site_tree`.
 */
class m171114_124604_create_site_tree_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('section', [
            'id' => $this->primaryKey()->unsigned(),
            'parent_id' => $this->integer()->defaultValue(null)->unsigned(),
            'language_id' => $this->integer()->unsigned()->notNull(),
            'title' => $this->string()->notNull(),
            'slug' => $this->string()->notNull(),
            'type' => $this->string()->notNull(),
            'meta_description' => $this->string(),
            'redirect_to' => $this->string(),
            'image' => $this->string(),
            'order_by' => $this->integer()->notNull(),
            'active' => $this->boolean()->notNull()->defaultValue(false),
        ], $tableOptions);
        $this->createIndex(
            'idx_section_parent',
            'section',
            'parent_id'
        );
        $this->createIndex(
            'idx_section_language',
            'section',
            'language_id'
        );
        $this->createIndex(
            'idx-section-title',
            'section',
            'title'
        );
        $this->createIndex(
            'idx-section-slug',
            'section',
            'slug'
        );
        $this->createIndex(
            'idx-section-type',
            'section',
            'type'
        );
        $this->createIndex(
            'idx-section-order_by',
            'section',
            'order_by'
        );
        $this->addForeignKey(
            'fk_section_parent',
            'section',
            'parent_id',
            'section',
            'id',
            'CASCADE'
        );
        $this->addForeignKey(
            'fk_section_language',
            'section',
            'language_id',
            'language',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk_section_language', 'section');
        $this->dropForeignKey('fk_section_parent', 'section');
        $this->dropTable('section');
    }
}
