<?php

namespace wdigital\cms\siteTree\controllers;

use wdigital\cms\siteTree\models\Html;
use wdigital\cms\siteTree\models\TranslatableHtml;
use wdigital\cms\siteTree\Module;
use Yii;
use yii\base\InvalidConfigException;
use yii\filters\AccessControl;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\Response;

class HtmlController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors(): array
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * @param int $id
     * @return string|Response
     * @throws NotFoundHttpException
     * @throws InvalidConfigException
     */
    public function actionIndex(int $id): Response|string
    {
        $module = Module::getInstance();
        Yii::$app->view->params['breadcrumbs'] = $module?->sectionClass::generateBackEndBreadCrumbArray($id);
        if (Yii::$app->request->isPost) {
            if ($module?->multipleSiteTree) {
                $modelClass = Yii::createObject(Html::class);
            } else {
                $modelClass = Yii::createObject(TranslatableHtml::class);
            }
        } else if ($module?->multipleSiteTree) {
            $modelClass = Yii::createObject(Html::class);
        } else {
            $modelClass = Yii::createObject(TranslatableHtml::class);
        }
        $model = $modelClass::find()->where(['section_id' => $id])->limit(1)->one();
        if ($model) {
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(Url::to(['default/index', 'id' => $id]));
            }
            if (!$module?->multipleSiteTree) {
                return $this->render('@wd-site-tree/views/section/html/single/edit', [
                    'model' => $model,
                ]);
            }
            return $this->render('@wd-site-tree/views/section/html/multiple/edit', [
                'model' => $model,
            ]);
        }
        throw new NotFoundHttpException();
    }
}
