<?php

namespace wdigital\cms\siteTree\models;

use wdigital\cms\siteTree\components\ContentTypeClassResolver;
use wdigital\cms\siteTree\interfaces\ContentTypeInterface;
use wdigital\cms\siteTree\Module;
use Yii;
use yii\base\InvalidConfigException;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;
use yii\web\NotFoundHttpException;

/**
 * @property mixed|null $title
 * @property-read ActiveQuery $parent
 */
class TreeSection extends ActiveRecord
{
    /**
     * @param string $slugs
     * @return array|bool
     * @throws InvalidConfigException
     */
    public static function renderView(string $slugs): bool|array
    {
        $contentTypeSlug = '';
        $section = static::findInTree(Yii::$app->view->params['site-tree'], ['fullSlug' => $slugs]);
        while (!($section && $section->type)) {
            $slugsExploded = explode('/', $slugs);
            $contentTypeSlug = '/' . array_pop($slugsExploded) . $contentTypeSlug;
            if (!$slugsExploded) {
                break;
            }
            $slugs = implode('/', $slugsExploded);
            $section = static::findInTree(Yii::$app->view->params['site-tree'], ['fullSlug' => $slugs]);
        }
        if ($section && $section->type) {
            $contentTypeResolver = new ContentTypeClassResolver();
            if ($section->parent_id) {
                $parentSection = static::findInTree(Yii::$app->view->params['site-tree'], ['id' => $section->parent_id]);
            } else {
                $parentSection = null;
            }
            Yii::$app->view->params['activeSection'] = $section;
            $classInstance = $contentTypeResolver->getContentTypeClassInstance($section->type);
            if ($classInstance instanceof ContentTypeInterface) {
                $viewContent = $contentTypeSlug ? $classInstance->getDetailedFrontendContent($section, $contentTypeSlug) : $classInstance->getFrontendContent($section);
                $view = $contentTypeSlug ? $classInstance->getContentTypeDetailedView() : $classInstance->getContentTypeView();
                return [
                    'view' => $view,
                    'section' => $section,
                    'parentSection' => $parentSection,
                    'content' => $viewContent,
                    'contentTypeSlug' => $contentTypeSlug
                ];
            }
            throw new InvalidConfigException('Specified class instance doesn\'t implement ContentTypeInterface');

        }
        return false;
    }

    /**
     * @param int $id
     * @return array
     * @throws NotFoundHttpException
     */
    public static function generateBackEndBreadCrumbArray(int $id): array
    {
        /** @var self $currentSection */
        $module = Module::getInstance();
        if ($module?->multipleSiteTree) {
            $currentSection = static::find()->where(['id' => $id])->limit(1)->one();
        } else {
            $currentSection = static::find()->joinWith('defaultTranslation')->where(['id' => $id])->limit(1)->one();
        }
        if (!$currentSection) {
            throw new NotFoundHttpException();
        }
        if ($module?->multipleSiteTree) {
            $sectionTitle = $currentSection->title;
        } else {
            $sectionTitle = $currentSection->title ?? '';
        }
        Yii::$app->view->title = $sectionTitle;
        $array[] = ['label' => $sectionTitle];
        $currentParent = $currentSection->parent;
        while ($currentParent) {
            if ($module?->multipleSiteTree) {
                $sectionTitle = $currentParent->title;
            } else {
                $sectionTitle = $currentParent->title ?? '';
            }
            $array[] = ['label' => $sectionTitle, 'url' => ['/site-tree/default/edit', 'id' => $currentParent->id]];
            $currentParent = $currentParent->parent;
        }
        $array[] = ['label' => Yii::t('site-tree', 'Site Tree'), 'url' => ['/site-tree/default/index']];
        return array_reverse($array);
    }
}
