<?php

namespace wdigital\cms\siteTree\models;

use Yii;
use yii\base\Model;
use yii\db\ActiveQuery;
use yii\db\ActiveRecord;
use yii\helpers\ArrayHelper;
use yii2tech\ar\variation\VariationBehavior;

/**
 * This is the model class for table "html".
 *
 * @property int $id
 * @property int $section_id
 *
 * @property $section
 * @property-read mixed $variationModels
 * @property-read ActiveQuery $defaultTranslation
 * @property TranslatableHtmlTranslation[] $htmlTranslations
 * @method getVariationModels()
 * @method hasDefaultVariationRelation()
 * @method setVariationModels(array $translationModels)
 */
class TranslatableHtml extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return '{{%html}}';
    }

    /**
     * @return array
     */
    public function behaviors(): array
    {
        return [
            'translations' => [
                'class' => VariationBehavior::class,
                'variationsRelation' => 'htmlTranslations',
                'defaultVariationRelation' => 'defaultTranslation',
                'variationOptionReferenceAttribute' => 'language_id',
                'optionModelClass' => Yii::$app->getModule('language')->languageClass,
                'defaultVariationOptionReference' => Yii::$app->getModule('language')->languageClass::getIdFromCode(Yii::$app->language),
                'variationModelDefaultAttributes' => [
                    'content' => '',
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['section_id'], 'required'],
            [['section_id'], 'integer'],
            [['section_id'],
                'exist',
                'skipOnError' => true,
                'targetClass' => Yii::$app->getModule('site-tree')->sectionClass,
                'targetAttribute' => ['section_id' => 'id']
            ],
            ['content', 'safe'],
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getHtmlTranslations(): ActiveQuery
    {
        return $this->hasMany(TranslatableHtmlTranslation::class, ['html_id' => 'id']);
    }

    /**
     * @return ActiveQuery
     */
    public function getDefaultTranslation(): ActiveQuery
    {
        return $this->hasDefaultVariationRelation();
    }

    /**
     * @return ActiveQuery
     */
    public function getSection(): ActiveQuery
    {
        return $this->hasOne(Yii::$app->getModule('site-tree')->sectionClass, ['id' => 'section_id']);
    }

    /**
     * @param array $data
     * @param null $formName
     * @return bool
     */
    public function load($data, $formName = null): bool
    {
        $translationModels = ArrayHelper::map(
            $this->getVariationModels(),
            'language_id',
            function ($translatedModel) {
                return $translatedModel;
            }
        );
        return Model::loadMultiple($translationModels, $data) && $this->setVariationModels($translationModels) ;
    }
}
