<?php

namespace wdigital\cms\siteTree\controllers;

use Throwable;
use wdigital\cms\siteTree\models\MultipleTreeSection;
use wdigital\cms\siteTree\models\SingleTreeSection;
use wdigital\cms\siteTree\Module;
use Yii;
use yii\base\InvalidConfigException;
use yii\filters\AccessControl;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\web\Response;

class DefaultController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors(): array
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    /**
     * @return string
     */
    public function actionIndex(): string
    {
        $module = Module::getInstance();
        if ($module?->multipleSiteTree) {
            return $this->render('@wd-site-tree/views/section/multiple/index');
        }
        return $this->render('@wd-site-tree/views/section/single/index');

    }

    /**
     * @return string|Response
     */
    public function actionAdd(): Response|string
    {
        /** @var Module $module */
        $module = Module::getInstance();
        $model = new $module?->sectionClass();
        $dropDownList = [];
        if (Yii::$app->request->isPost &&
            $model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(Url::to(['index']));
        }
        if ($parent_id = Yii::$app->request->get('parent_id')) {
            if ($module?->multipleSiteTree) {
                $parents = $module?->sectionClass::find()->select('title')->where(['id' => $parent_id])->limit(1)
                    ->indexBy('id')->column();
            } else {
                $parents = $module?->sectionClass::find()->innerJoinWith('defaultTranslation')->select('title')
                    ->where(['id' => $parent_id])->limit(1)->indexBy('id')->column();
            }
            $model->parent_id = $parent_id;
        } else {
            $parents = [];
        }
        if ($module?->content_types) {
            foreach ($module?->content_types as $contentType) {
                $dropDownList[$contentType['value']] = Yii::t($contentType['category'], $contentType['label']);
            }
        }
        if ($module?->multipleSiteTree) {
            return $this->render('@wd-site-tree/views/section/multiple/create', [
                'parents' => $parents,
                'model' => $model,
                'dropDownList' => $dropDownList
            ]);
        }
        return $this->render('@wd-site-tree/views/section/single/create', [
            'parents' => $parents,
            'model' => $model,
            'dropDownList' => $dropDownList
        ]);
    }

    /**
     * @param $id
     * @return string|Response
     * @throws NotFoundHttpException
     */
    public function actionEdit($id): Response|string
    {
        $module = Module::getInstance();
        /** @var SingleTreeSection|MultipleTreeSection $model */
        $model = $module?->sectionClass::find()->where(['id' => $id])->limit(1)->one();
        $dropDownList = [];
        if (!$model) {
            throw new NotFoundHttpException();
        }
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(Url::to(['default/edit', 'id' => $model->id]));
        }
        if ($model->parent_id) {
            if ($module?->multipleSiteTree) {
                $parents = $module?->sectionClass::find()->select('title')->where(['id' => $model->parent_id])
                        ->limit(1)->indexBy('id')->column();
                } else {
                    $parents = $module?->sectionClass::find()->innerJoinWith('defaultTranslation')->select('title')
                        ->where(['id' => $model->parent_id])->limit(1)->indexBy('id')->column();
                }
            } else {
                $parents = [];
            }
            if ($module?->content_types) {
            foreach ($module?->content_types as $contentType) {
                $dropDownList[$contentType['value']] = Yii::t($contentType['category'], $contentType['label']);
            }
        }
        $siteTree = $module?->sectionClass::buildSiteTree();
        if ($module?->multipleSiteTree) {
            return $this->render('@wd-site-tree/views/section/multiple/edit', [
                'sections' => $siteTree,
                'model' => $model,
                'parents' => $parents,
                'dropDownList' => $dropDownList
            ]);
        }
        return $this->render('@wd-site-tree/views/section/single/edit', [
            'sections' => $siteTree,
            'model' => $model,
            'parents' => $parents,
            'dropDownList' => $dropDownList
        ]);
    }

    public function actionTreeOrderChange(): void
    {
        $post = Yii::$app->request->post();
        $module = Module::getInstance();
        /** @var SingleTreeSection|MultipleTreeSection $section */
        $section = new $module?->sectionClass();
        $foundSection = $section::find()->where(['id' => $post['node_id']])->one();
        $section->changeOrder($foundSection, $post);
    }

    /**
     * @param $id
     * @return Response
     * @throws NotFoundHttpException
     * @throws Throwable
     */
    public function actionDelete($id): Response
    {
        $module = Module::getInstance();
        /** @var SingleTreeSection|MultipleTreeSection $model */
        if ($model = $module?->sectionClass::find()->where(['id' => $id])->limit(1)->one()) {
            $model->delete();
            return $this->redirect(Url::to(['index']));
        }
        throw new NotFoundHttpException();
    }

    /**
     * @return array
     * @throws NotFoundHttpException
     * @throws InvalidConfigException
     */
    public function actionGetSiteTreeData(): array
    {
        if (!Yii::$app->request->isAjax) {
            throw new NotFoundHttpException();
        }
        Yii::$app->response->format = Response::FORMAT_JSON;
        $modelClass = Yii::createObject(MultipleTreeSection::class);
        return $modelClass::buildSiteTree();
    }
}
