<?php

namespace wdigital\cms\siteTree;

use wdigital\cms\siteTree\models\Html;
use wdigital\cms\siteTree\models\MultipleTreeSection;
use wdigital\cms\siteTree\models\SingleTreeSection;
use wdigital\cms\siteTree\models\SingleTreeSectionTranslation;
use wdigital\cms\siteTree\models\TranslatableHtml;
use wdigital\cms\siteTree\models\TranslatableHtmlTranslation;
use wdigital\cms\siteTree\models\TreeSection;
use Yii;
use yii\base\Module as BaseModule;
use yii\helpers\StringHelper;

class Module extends BaseModule
{
    public array $content_types;

    public bool $multipleSiteTree;

    public string $sectionClass;

    public string $ajaxDataUrl = 'get-site-tree-data';

    public array $modelMap = [
        'Html' => Html::class,
        'MultipleTreeSection' => MultipleTreeSection::class,
        'SingleTreeSection' => SingleTreeSection::class,
        'SingleTreeSectionTranslation' => SingleTreeSectionTranslation::class,
        'TranslatableHtml' => TranslatableHtml::class,
        'TranslatableHtmlTranslation' => TranslatableHtmlTranslation::class,
        'TreeSection' => TreeSection::class,
    ];

    public function __construct($id, $parent = null, array $config = [])
    {
        if (empty($config['content_types'])) {
            $config['content_types'] = [
                ['value' => 'html', 'label' => 'HTML section', 'category' => 'site-tree', 'class' => models\Html::class],
                ['value' => 'redirect', 'label' => 'Redirect section', 'category' => 'site-tree'],
                ['value' => 'gdpr', 'label' => 'GDPR section', 'category' => 'site-tree']
            ];
        }
        if (!isset($config['multipleSiteTree'])) {
            $config['multipleSiteTree'] = true;
            $config['content_types'] = [
                ['value' => 'html', 'label' => 'HTML section', 'category' => 'site-tree', 'class' => models\Html::class],
                ['value' => 'redirect', 'label' => 'Redirect section', 'category' => 'site-tree'],
                ['value' => 'gdpr', 'label' => 'GDPR section', 'category' => 'site-tree']
            ];
        }
        if (!isset($config['sectionClass'])) {
            if ($config['multipleSiteTree']) {
                $config['sectionClass'] = MultipleTreeSection::class;
            } else {
                $config['sectionClass'] = SingleTreeSection::class;
            }
        }
        parent::__construct($id, $parent, $config);
    }

    /**
     * @inheritdoc
     */
    public function init(): void
    {
        parent::init();
        $this->overrideModels();
    }

    /**
     * @return void
     */
    private function overrideModels(): void
    {
        foreach ($this->modelMap as $name => $definition) {
            $modelName = is_array($definition)
                ? $definition['class']
                : $definition;
            if (is_int($name)) {
                $name = StringHelper::basename($modelName);
            }
            Yii::$container->set('wdigital\\cms\\siteTree\\models\\' . $name, $definition);
            $this->modelMap[$name] = $modelName;
        }
    }
}
