<?php

namespace wdigital\cms\siteTree\widgets;

use dosamigos\ckeditor\CKEditor as BaseCKEditor;
use mihaildev\elfinder\Assets;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;

class CKEditor extends BaseCKEditor
{
    public $enableFileManager = true;

    /**
     * Registers CKEditor plugin
     */
    protected function registerPlugin(): void
    {
        if ($this->enableFileManager)
        {
            $this->registerFileManager();
        }

        parent::registerPlugin();
    }

    /**
     * Registers File manager
     */
    protected function registerFileManager(): void
    {
        Assets::register($this->view);
        $browseOptions = [
            'filebrowserBrowseUrl' => Url::to(['/webfiles/manager']),
            'toolbarGroups' => [
                ['name' => 'clipboard', 'groups' => ['mode', 'undo', 'selection', 'clipboard', 'doctools']],
                ['name' => 'editing', 'groups' => ['tools', 'about']],
                '/',
                ['name' => 'paragraph', 'groups' => ['templates', 'list', 'indent', 'align']],
                ['name' => 'insert'],
                '/',
                ['name' => 'basicstyles', 'groups' => ['basicstyles', 'cleanup']],
                ['name' => 'colors'],
                ['name' => 'links'],
                ['name' => 'others'],
                ['name' => 'styles', 'groups' => ['styles']],
            ],
            'removeButtons' => 'Styles,Font,FontSize,Flash'
        ];

        $this->clientOptions = ArrayHelper::merge($this->clientOptions, $browseOptions);
    }
}