<?php

namespace wdigital\cms\siteTree\migrations\multiple;

use yii\db\Migration;

/**
 * Handles the creation of table `html`.
 */
class m171114_135056_create_html_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            // http://stackoverflow.com/questions/766809/whats-the-difference-between-utf8-general-ci-and-utf8-unicode-ci
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('html', [
            'id' => $this->primaryKey()->unsigned(),
            'section_id' => $this->integer()->notNull()->unsigned(),
            'content' => $this->text(),
        ], $tableOptions);

        $this->createIndex(
            'idx_html_section',
            'html',
            'section_id'
        );

        $this->addForeignKey(
            'fk_html_section',
            'html',
            'section_id',
            'section',
            'id',
            'CASCADE'
        );
    }

    /**
     * @inheritdoc
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk_html_section', 'html');
        $this->dropIndex('idx_html_section', 'html');
        $this->dropTable('html');
    }

}
