<?php

use wdigital\cms\siteTree\widgets\CKEditor;
use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$this->title = Yii::t('site-tree', 'Edit the HTML content:') . ' ' . $model->section->title;
?>
<div>
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h3><?= Html::encode($this->title) ?></h3>
                    <small><?= Yii::t('site-tree', 'By submitting this form you are updating the HTML content.') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'edit-form',
                                'options' => ['role' => 'form', 'method' => 'POST'],
                                'action' => ['', 'lang' => Yii::$app->language, 'id' => $model->id],
                            ])
                    ?>
                    <ul class="nav nav-tabs col-sm-12 lang-tabs-style">
                        <?php foreach (Yii::$app->params['languages'] as $language): ?>
                            <li <?php if (Yii::$app->language === $language['code']): ?> class="active" <?php endif ?> >
                                <a
                                        href="#new-<?= $language['code'] ?>"
                                        data-toggle="tab"><?= Html::encode($language['name']); ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                    <div class="tab-content">
                        <?php foreach (Yii::$app->params['languages'] as $language): ?>
                            <div class="tab-pane fade in <?php if (Yii::$app->language === $language['code']): ?> active <?php endif; ?>"
                                 id="new-<?= $language['code'] ?>">
                                <?php $translatedModel = $model->getVariationModel($language['id']); ?>
                                <?= $form->field($translatedModel, "[{$language['id']}]content")
                                    ->widget(CKEditor::class, ['options' => ['rows' => 6]])
                                    ->label(Yii::t('site-tree', 'Content', [], $language['code'])); ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('site-tree', 'Save'), ['class' => 'btn btn-primary', 'name' => 'edit-button']) ?>
                    </div>
                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
