<?php

namespace wdigital\cms\siteTree\models;


use yii\db\ActiveRecord;


/**
 * This is the model class for table "section_translation".
 *
 * @property int $section_id [int(11) unsigned]
 * @property int $language_id [int(11) unsigned]
 * @property string $title [varchar(255)]
 * @property string $slug [varchar(255)]
 * @property string $meta_description [varchar(255)]
 * @property string $redirect_to [varchar(255)]
 * @property string $meta_title [varchar(255)]
 */
class SingleTreeSectionTranslation extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName(): string
    {
        return '{{%section_translation}}';
    }

    /**
     * @inheritdoc
     */
    public function rules(): array
    {
        return [
            [['language_id'], 'required'],
            [['section_id', 'language_id'], 'integer'],
            [['title', 'slug', 'redirect_to'], 'string', 'max' => 255],
            [['meta_title'], 'string', 'max' => 60],
            [['meta_description'], 'string', 'max' => 150],
            [['section_id', 'language_id'], 'unique', 'targetAttribute' => ['section_id', 'language_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels(): array
    {
        return [
            'section_id' => \Yii::t('site-tree', 'Section ID'),
            'language_id' => \Yii::t('site-tree', 'Language ID'),
            'title' => \Yii::t('site-tree', 'Title'),
            'slug' => \Yii::t('site-tree', 'Slug'),
            'redirect_to' => \Yii::t('site-tree', 'Redirect to'),
            'meta_title' => \Yii::t('site-tree', 'Meta title'),
            'meta_description' => \Yii::t('site-tree', 'Meta description'),
        ];
    }

    /**
     * @return array
     */
    public static function fillable(): array
    {
        return [
            'title',
            'slug',
            'redirect_to',
            'meta_description',
            'meta_title'
        ];
    }
}