<?php

use yii\helpers\Html;
use yii\web\View;
use yii\widgets\ActiveForm;

/* @var $this View */
$this->title = Yii::t('site-tree', 'Create a new section');
$this->params['breadcrumbs'][] = ['label' => Yii::t('site-tree', 'Site Tree'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div>
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox animated fadeInUp">
                <div class="ibox-title">
                    <h3><?= Html::encode($this->title) ?></h3>
                    <small><?= Yii::t('site-tree', 'By submitting this form you create a new section.') ?></small>
                </div>
                <div class="ibox-content">
                    <?php
                    $form = ActiveForm::begin([
                                'id' => 'create-form',
                                'options' => ['role' => 'form', 'method' => 'POST']
                            ])
                    ?>
                    <?= $form->field($model, 'parent_id')->dropDownList($parents, ['prompt' => ['text' => Yii::t('site-tree', 'None'), 'options' => ['value' => 0]]]) ?>
                    <?= $form->field($model, 'type')->dropDownList($dropDownList, ['prompt' => ['text' => Yii::t('site-tree', 'None'), 'options' => ['value' => 0]]]); ?>
                    <?= $form->field($model, 'title')->textInput(['class' => 'form-control js-slug-field', 'data-slug-field' => 'new-title']) ?>
                    <?= $form->field($model, 'slug')->textInput(['data-slug-target' => 'new-title']) ?>
                    <?= $form->field($model, 'meta_title')->textInput(['class' => 'form-control', 'maxlength' => 60]) ?>
                    <?= $form->field($model, 'meta_description')->textInput(['class' => 'form-control', 'maxlength' => 150]) ?>
                    <?= $form->field($model, 'active')->checkbox(['class' => 'js-switch']) ?>
                    <div class="form-group">
                        <?= Html::submitButton(Yii::t('site-tree', 'Save'), ['class' => 'btn btn-primary', 'name' => 'submit-button']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
